package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterClusterNode(
    nodeRole: Option[NonEmptyString] = None,
    privateIpAddress: Option[NonEmptyString] = None,
    publicIpAddress: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode = {
    import AwsRedshiftClusterClusterNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
      .builder()
      .optionallyWith(
        nodeRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nodeRole)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .optionallyWith(
        publicIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicIpAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterClusterNode
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterClusterNode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterClusterNode =
      zio.aws.securityhub.model.AwsRedshiftClusterClusterNode(
        nodeRole.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value)
      )
    def nodeRole: Option[NonEmptyString]
    def privateIpAddress: Option[NonEmptyString]
    def publicIpAddress: Option[NonEmptyString]
    def getNodeRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nodeRole", nodeRole)
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly {
    override val nodeRole: Option[NonEmptyString] = scala
      .Option(impl.nodeRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val privateIpAddress: Option[NonEmptyString] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIpAddress: Option[NonEmptyString] = scala
      .Option(impl.publicIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterNode
  ): zio.aws.securityhub.model.AwsRedshiftClusterClusterNode.ReadOnly =
    new Wrapper(impl)
}
