package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsEventSubscriptionDetails(
    custSubscriptionId: Option[NonEmptyString] = None,
    customerAwsId: Option[NonEmptyString] = None,
    enabled: Option[Boolean] = None,
    eventCategoriesList: Option[Iterable[NonEmptyString]] = None,
    eventSubscriptionArn: Option[NonEmptyString] = None,
    snsTopicArn: Option[NonEmptyString] = None,
    sourceIdsList: Option[Iterable[NonEmptyString]] = None,
    sourceType: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    subscriptionCreationTime: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails = {
    import AwsRdsEventSubscriptionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
      .builder()
      .optionallyWith(
        custSubscriptionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.custSubscriptionId)
      .optionallyWith(
        customerAwsId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customerAwsId)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        eventCategoriesList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategoriesList)
      .optionallyWith(
        eventSubscriptionArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.eventSubscriptionArn)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        sourceIdsList.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceIdsList)
      .optionallyWith(
        sourceType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceType)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        subscriptionCreationTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.subscriptionCreationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails
      .wrap(buildAwsValue())
}
object AwsRdsEventSubscriptionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails =
      zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails(
        custSubscriptionId.map(value => value),
        customerAwsId.map(value => value),
        enabled.map(value => value),
        eventCategoriesList.map(value => value),
        eventSubscriptionArn.map(value => value),
        snsTopicArn.map(value => value),
        sourceIdsList.map(value => value),
        sourceType.map(value => value),
        status.map(value => value),
        subscriptionCreationTime.map(value => value)
      )
    def custSubscriptionId: Option[NonEmptyString]
    def customerAwsId: Option[NonEmptyString]
    def enabled: Option[Boolean]
    def eventCategoriesList: Option[List[NonEmptyString]]
    def eventSubscriptionArn: Option[NonEmptyString]
    def snsTopicArn: Option[NonEmptyString]
    def sourceIdsList: Option[List[NonEmptyString]]
    def sourceType: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def subscriptionCreationTime: Option[NonEmptyString]
    def getCustSubscriptionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionId)
    def getCustomerAwsId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customerAwsId", customerAwsId)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEventCategoriesList: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesList)
    def getEventSubscriptionArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArn)
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getSourceIdsList: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("sourceIdsList", sourceIdsList)
    def getSourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getSubscriptionCreationTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "subscriptionCreationTime",
        subscriptionCreationTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ) extends zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly {
    override val custSubscriptionId: Option[NonEmptyString] = scala
      .Option(impl.custSubscriptionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val customerAwsId: Option[NonEmptyString] = scala
      .Option(impl.customerAwsId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val eventCategoriesList: Option[List[NonEmptyString]] = scala
      .Option(impl.eventCategoriesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val eventSubscriptionArn: Option[NonEmptyString] = scala
      .Option(impl.eventSubscriptionArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snsTopicArn: Option[NonEmptyString] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceIdsList: Option[List[NonEmptyString]] = scala
      .Option(impl.sourceIdsList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val sourceType: Option[NonEmptyString] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subscriptionCreationTime: Option[NonEmptyString] = scala
      .Option(impl.subscriptionCreationTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsEventSubscriptionDetails
  ): zio.aws.securityhub.model.AwsRdsEventSubscriptionDetails.ReadOnly =
    new Wrapper(impl)
}
