package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSubnetGroupSubnetAvailabilityZone(
    name: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone = {
    import AwsRdsDbSubnetGroupSubnetAvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
      .wrap(buildAwsValue())
}
object AwsRdsDbSubnetGroupSubnetAvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone =
      zio.aws.securityhub.model
        .AwsRdsDbSubnetGroupSubnetAvailabilityZone(name.map(value => value))
    def name: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
  ) extends zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone
  ): zio.aws.securityhub.model.AwsRdsDbSubnetGroupSubnetAvailabilityZone.ReadOnly =
    new Wrapper(impl)
}
