package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbStatusInfo(
    statusType: Option[NonEmptyString] = None,
    normal: Option[Boolean] = None,
    status: Option[NonEmptyString] = None,
    message: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo = {
    import AwsRdsDbStatusInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
      .builder()
      .optionallyWith(
        statusType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.statusType)
      .optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        message.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbStatusInfo.wrap(buildAwsValue())
}
object AwsRdsDbStatusInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbStatusInfo =
      zio.aws.securityhub.model.AwsRdsDbStatusInfo(
        statusType.map(value => value),
        normal.map(value => value),
        status.map(value => value),
        message.map(value => value)
      )
    def statusType: Option[NonEmptyString]
    def normal: Option[Boolean]
    def status: Option[NonEmptyString]
    def message: Option[NonEmptyString]
    def getStatusType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusType", statusType)
    def getNormal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("normal", normal)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ) extends zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly {
    override val statusType: Option[NonEmptyString] = scala
      .Option(impl.statusType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val normal: Option[Boolean] =
      scala.Option(impl.normal()).map(value => value: Boolean)
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val message: Option[NonEmptyString] = scala
      .Option(impl.message())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo
  ): zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly = new Wrapper(impl)
}
