package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceDetails(
    associatedRoles: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole]
    ] = None,
    caCertificateIdentifier: Option[NonEmptyString] = None,
    dbClusterIdentifier: Option[NonEmptyString] = None,
    dbInstanceIdentifier: Option[NonEmptyString] = None,
    dbInstanceClass: Option[NonEmptyString] = None,
    dbInstancePort: Option[Integer] = None,
    dbiResourceId: Option[NonEmptyString] = None,
    dbName: Option[NonEmptyString] = None,
    deletionProtection: Option[Boolean] = None,
    endpoint: Option[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint] = None,
    engine: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    iamDatabaseAuthenticationEnabled: Option[Boolean] = None,
    instanceCreateTime: Option[NonEmptyString] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    publiclyAccessible: Option[Boolean] = None,
    storageEncrypted: Option[Boolean] = None,
    tdeCredentialArn: Option[NonEmptyString] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup]
    ] = None,
    multiAz: Option[Boolean] = None,
    enhancedMonitoringResourceArn: Option[NonEmptyString] = None,
    dbInstanceStatus: Option[NonEmptyString] = None,
    masterUsername: Option[NonEmptyString] = None,
    allocatedStorage: Option[Integer] = None,
    preferredBackupWindow: Option[NonEmptyString] = None,
    backupRetentionPeriod: Option[Integer] = None,
    dbSecurityGroups: Option[Iterable[NonEmptyString]] = None,
    dbParameterGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbParameterGroup]
    ] = None,
    availabilityZone: Option[NonEmptyString] = None,
    dbSubnetGroup: Option[zio.aws.securityhub.model.AwsRdsDbSubnetGroup] = None,
    preferredMaintenanceWindow: Option[NonEmptyString] = None,
    pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues
    ] = None,
    latestRestorableTime: Option[NonEmptyString] = None,
    autoMinorVersionUpgrade: Option[Boolean] = None,
    readReplicaSourceDBInstanceIdentifier: Option[NonEmptyString] = None,
    readReplicaDBInstanceIdentifiers: Option[Iterable[NonEmptyString]] = None,
    readReplicaDBClusterIdentifiers: Option[Iterable[NonEmptyString]] = None,
    licenseModel: Option[NonEmptyString] = None,
    iops: Option[Integer] = None,
    optionGroupMemberships: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership]
    ] = None,
    characterSetName: Option[NonEmptyString] = None,
    secondaryAvailabilityZone: Option[NonEmptyString] = None,
    statusInfos: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbStatusInfo]
    ] = None,
    storageType: Option[NonEmptyString] = None,
    domainMemberships: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbDomainMembership]
    ] = None,
    copyTagsToSnapshot: Option[Boolean] = None,
    monitoringInterval: Option[Integer] = None,
    monitoringRoleArn: Option[NonEmptyString] = None,
    promotionTier: Option[Integer] = None,
    timezone: Option[NonEmptyString] = None,
    performanceInsightsEnabled: Option[Boolean] = None,
    performanceInsightsKmsKeyId: Option[NonEmptyString] = None,
    performanceInsightsRetentionPeriod: Option[Integer] = None,
    enabledCloudWatchLogsExports: Option[Iterable[NonEmptyString]] = None,
    processorFeatures: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = None,
    listenerEndpoint: Option[
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint
    ] = None,
    maxAllocatedStorage: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails = {
    import AwsRdsDbInstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
      .builder()
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        caCertificateIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.caCertificateIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        dbInstanceClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceClass)
      .optionallyWith(
        dbInstancePort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.dbInstancePort)
      .optionallyWith(
        dbiResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbiResourceId)
      .optionallyWith(
        dbName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dbName)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        instanceCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceCreateTime)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        tdeCredentialArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tdeCredentialArn)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(multiAz.map(value => value: java.lang.Boolean))(_.multiAz)
      .optionallyWith(
        enhancedMonitoringResourceArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.enhancedMonitoringResourceArn)
      .optionallyWith(
        dbInstanceStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceStatus)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        allocatedStorage.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.allocatedStorage)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.latestRestorableTime)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        readReplicaSourceDBInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.readReplicaSourceDBInstanceIdentifier)
      .optionallyWith(
        readReplicaDBInstanceIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBInstanceIdentifiers)
      .optionallyWith(
        readReplicaDBClusterIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBClusterIdentifiers)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        iops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.iops)
      .optionallyWith(
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupMemberships)
      .optionallyWith(
        characterSetName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.characterSetName)
      .optionallyWith(
        secondaryAvailabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.monitoringInterval)
      .optionallyWith(
        monitoringRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.monitoringRoleArn)
      .optionallyWith(
        promotionTier.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.promotionTier)
      .optionallyWith(
        timezone.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKmsKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.performanceInsightsKmsKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enabledCloudWatchLogsExports.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudWatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(listenerEndpoint.map(value => value.buildAwsValue()))(
        _.listenerEndpoint
      )
      .optionallyWith(
        maxAllocatedStorage.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maxAllocatedStorage)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceDetails.wrap(buildAwsValue())
}
object AwsRdsDbInstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceDetails =
      zio.aws.securityhub.model.AwsRdsDbInstanceDetails(
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        caCertificateIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbInstanceIdentifier.map(value => value),
        dbInstanceClass.map(value => value),
        dbInstancePort.map(value => value),
        dbiResourceId.map(value => value),
        dbName.map(value => value),
        deletionProtection.map(value => value),
        endpoint.map(value => value.asEditable),
        engine.map(value => value),
        engineVersion.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        instanceCreateTime.map(value => value),
        kmsKeyId.map(value => value),
        publiclyAccessible.map(value => value),
        storageEncrypted.map(value => value),
        tdeCredentialArn.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAz.map(value => value),
        enhancedMonitoringResourceArn.map(value => value),
        dbInstanceStatus.map(value => value),
        masterUsername.map(value => value),
        allocatedStorage.map(value => value),
        preferredBackupWindow.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbSecurityGroups.map(value => value),
        dbParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        dbSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        latestRestorableTime.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        readReplicaSourceDBInstanceIdentifier.map(value => value),
        readReplicaDBInstanceIdentifiers.map(value => value),
        readReplicaDBClusterIdentifiers.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        characterSetName.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        statusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        domainMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        promotionTier.map(value => value),
        timezone.map(value => value),
        performanceInsightsEnabled.map(value => value),
        performanceInsightsKmsKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enabledCloudWatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listenerEndpoint.map(value => value.asEditable),
        maxAllocatedStorage.map(value => value)
      )
    def associatedRoles: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly]
    ]
    def caCertificateIdentifier: Option[NonEmptyString]
    def dbClusterIdentifier: Option[NonEmptyString]
    def dbInstanceIdentifier: Option[NonEmptyString]
    def dbInstanceClass: Option[NonEmptyString]
    def dbInstancePort: Option[Integer]
    def dbiResourceId: Option[NonEmptyString]
    def dbName: Option[NonEmptyString]
    def deletionProtection: Option[Boolean]
    def endpoint
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly]
    def engine: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Option[Boolean]
    def instanceCreateTime: Option[NonEmptyString]
    def kmsKeyId: Option[NonEmptyString]
    def publiclyAccessible: Option[Boolean]
    def storageEncrypted: Option[Boolean]
    def tdeCredentialArn: Option[NonEmptyString]
    def vpcSecurityGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ]
    def multiAz: Option[Boolean]
    def enhancedMonitoringResourceArn: Option[NonEmptyString]
    def dbInstanceStatus: Option[NonEmptyString]
    def masterUsername: Option[NonEmptyString]
    def allocatedStorage: Option[Integer]
    def preferredBackupWindow: Option[NonEmptyString]
    def backupRetentionPeriod: Option[Integer]
    def dbSecurityGroups: Option[List[NonEmptyString]]
    def dbParameterGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly]
    ]
    def availabilityZone: Option[NonEmptyString]
    def dbSubnetGroup
        : Option[zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Option[NonEmptyString]
    def pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ]
    def latestRestorableTime: Option[NonEmptyString]
    def autoMinorVersionUpgrade: Option[Boolean]
    def readReplicaSourceDBInstanceIdentifier: Option[NonEmptyString]
    def readReplicaDBInstanceIdentifiers: Option[List[NonEmptyString]]
    def readReplicaDBClusterIdentifiers: Option[List[NonEmptyString]]
    def licenseModel: Option[NonEmptyString]
    def iops: Option[Integer]
    def optionGroupMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly]
    ]
    def characterSetName: Option[NonEmptyString]
    def secondaryAvailabilityZone: Option[NonEmptyString]
    def statusInfos
        : Option[List[zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly]]
    def storageType: Option[NonEmptyString]
    def domainMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ]
    def copyTagsToSnapshot: Option[Boolean]
    def monitoringInterval: Option[Integer]
    def monitoringRoleArn: Option[NonEmptyString]
    def promotionTier: Option[Integer]
    def timezone: Option[NonEmptyString]
    def performanceInsightsEnabled: Option[Boolean]
    def performanceInsightsKmsKeyId: Option[NonEmptyString]
    def performanceInsightsRetentionPeriod: Option[Integer]
    def enabledCloudWatchLogsExports: Option[List[NonEmptyString]]
    def processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def listenerEndpoint
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly]
    def maxAllocatedStorage: Option[Integer]
    def getAssociatedRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "caCertificateIdentifier",
        caCertificateIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDbInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstancePort", dbInstancePort)
    def getDbiResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getDbName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getInstanceCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getTdeCredentialArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getMultiAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAz", multiAz)
    def getEnhancedMonitoringResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "enhancedMonitoringResourceArn",
        enhancedMonitoringResourceArn
      )
    def getDbInstanceStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getReadReplicaSourceDBInstanceIdentifier
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "readReplicaSourceDBInstanceIdentifier",
      readReplicaSourceDBInstanceIdentifier
    )
    def getReadReplicaDBInstanceIdentifiers
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "readReplicaDBInstanceIdentifiers",
      readReplicaDBInstanceIdentifiers
    )
    def getReadReplicaDBClusterIdentifiers
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "readReplicaDBClusterIdentifiers",
      readReplicaDBClusterIdentifiers
    )
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupMemberships",
      optionGroupMemberships
    )
    def getCharacterSetName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "secondaryAvailabilityZone",
        secondaryAvailabilityZone
      )
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPromotionTier: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getTimezone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "performanceInsightsKmsKeyId",
        performanceInsightsKmsKeyId
      )
    def getPerformanceInsightsRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "performanceInsightsRetentionPeriod",
        performanceInsightsRetentionPeriod
      )
    def getEnabledCloudWatchLogsExports
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "enabledCloudWatchLogsExports",
      enabledCloudWatchLogsExports
    )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getListenerEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("listenerEndpoint", listenerEndpoint)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly {
    override val associatedRoles: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly]
    ] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.wrap(item)
        }.toList
      )
    override val caCertificateIdentifier: Option[NonEmptyString] = scala
      .Option(impl.caCertificateIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbClusterIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbInstanceIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbInstanceClass: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceClass())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbInstancePort: Option[Integer] = scala
      .Option(impl.dbInstancePort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val dbiResourceId: Option[NonEmptyString] = scala
      .Option(impl.dbiResourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbName: Option[NonEmptyString] = scala
      .Option(impl.dbName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deletionProtection: Option[Boolean] =
      scala.Option(impl.deletionProtection()).map(value => value: Boolean)
    override val endpoint
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly] =
      scala
        .Option(impl.endpoint())
        .map(value =>
          zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.wrap(value)
        )
    override val engine: Option[NonEmptyString] = scala
      .Option(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamDatabaseAuthenticationEnabled: Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val instanceCreateTime: Option[NonEmptyString] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publiclyAccessible: Option[Boolean] =
      scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val tdeCredentialArn: Option[NonEmptyString] = scala
      .Option(impl.tdeCredentialArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcSecurityGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.wrap(item)
        }.toList
      )
    override val multiAz: Option[Boolean] =
      scala.Option(impl.multiAz()).map(value => value: Boolean)
    override val enhancedMonitoringResourceArn: Option[NonEmptyString] = scala
      .Option(impl.enhancedMonitoringResourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbInstanceStatus: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Option[Integer] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val preferredBackupWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredBackupWindow())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val backupRetentionPeriod: Option[Integer] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val dbSecurityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val dbParameterGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbParameterGroup.ReadOnly]
    ] = scala
      .Option(impl.dbParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbParameterGroup.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[NonEmptyString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbSubnetGroup
        : Option[zio.aws.securityhub.model.AwsRdsDbSubnetGroup.ReadOnly] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.securityhub.model.AwsRdsDbSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val pendingModifiedValues: Option[
      zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.ReadOnly
    ] = scala
      .Option(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.securityhub.model.AwsRdsDbPendingModifiedValues.wrap(value)
      )
    override val latestRestorableTime: Option[NonEmptyString] = scala
      .Option(impl.latestRestorableTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val autoMinorVersionUpgrade: Option[Boolean] =
      scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
    override val readReplicaSourceDBInstanceIdentifier: Option[NonEmptyString] =
      scala
        .Option(impl.readReplicaSourceDBInstanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val readReplicaDBInstanceIdentifiers
        : Option[List[NonEmptyString]] = scala
      .Option(impl.readReplicaDBInstanceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val readReplicaDBClusterIdentifiers: Option[List[NonEmptyString]] =
      scala
        .Option(impl.readReplicaDBClusterIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val licenseModel: Option[NonEmptyString] = scala
      .Option(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Option[Integer] = scala
      .Option(impl.iops())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val optionGroupMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.ReadOnly]
    ] = scala
      .Option(impl.optionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbOptionGroupMembership.wrap(item)
        }.toList
      )
    override val characterSetName: Option[NonEmptyString] = scala
      .Option(impl.characterSetName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val secondaryAvailabilityZone: Option[NonEmptyString] = scala
      .Option(impl.secondaryAvailabilityZone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statusInfos
        : Option[List[zio.aws.securityhub.model.AwsRdsDbStatusInfo.ReadOnly]] =
      scala
        .Option(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsRdsDbStatusInfo.wrap(item)
          }.toList
        )
    override val storageType: Option[NonEmptyString] = scala
      .Option(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ] = scala
      .Option(impl.domainMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbDomainMembership.wrap(item)
        }.toList
      )
    override val copyTagsToSnapshot: Option[Boolean] =
      scala.Option(impl.copyTagsToSnapshot()).map(value => value: Boolean)
    override val monitoringInterval: Option[Integer] = scala
      .Option(impl.monitoringInterval())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val monitoringRoleArn: Option[NonEmptyString] = scala
      .Option(impl.monitoringRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val promotionTier: Option[Integer] = scala
      .Option(impl.promotionTier())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val timezone: Option[NonEmptyString] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val performanceInsightsEnabled: Option[Boolean] = scala
      .Option(impl.performanceInsightsEnabled())
      .map(value => value: Boolean)
    override val performanceInsightsKmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.performanceInsightsKmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val performanceInsightsRetentionPeriod: Option[Integer] = scala
      .Option(impl.performanceInsightsRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val enabledCloudWatchLogsExports: Option[List[NonEmptyString]] =
      scala
        .Option(impl.enabledCloudWatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = scala
      .Option(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
    override val listenerEndpoint
        : Option[zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.ReadOnly] =
      scala
        .Option(impl.listenerEndpoint())
        .map(value =>
          zio.aws.securityhub.model.AwsRdsDbInstanceEndpoint.wrap(value)
        )
    override val maxAllocatedStorage: Option[Integer] = scala
      .Option(impl.maxAllocatedStorage())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceDetails
  ): zio.aws.securityhub.model.AwsRdsDbInstanceDetails.ReadOnly = new Wrapper(
    impl
  )
}
