package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbInstanceAssociatedRole(
    roleArn: Option[NonEmptyString] = None,
    featureName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole = {
    import AwsRdsDbInstanceAssociatedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
      .builder()
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        featureName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.featureName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole
      .wrap(buildAwsValue())
}
object AwsRdsDbInstanceAssociatedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole =
      zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole(
        roleArn.map(value => value),
        featureName.map(value => value),
        status.map(value => value)
      )
    def roleArn: Option[NonEmptyString]
    def featureName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ) extends zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly {
    override val roleArn: Option[NonEmptyString] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val featureName: Option[NonEmptyString] = scala
      .Option(impl.featureName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole
  ): zio.aws.securityhub.model.AwsRdsDbInstanceAssociatedRole.ReadOnly =
    new Wrapper(impl)
}
