package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbDomainMembership(
    domain: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    fqdn: Option[NonEmptyString] = None,
    iamRoleName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership = {
    import AwsRdsDbDomainMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership
      .builder()
      .optionallyWith(
        domain.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        fqdn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.fqdn)
      .optionallyWith(
        iamRoleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.iamRoleName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbDomainMembership.wrap(buildAwsValue())
}
object AwsRdsDbDomainMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbDomainMembership =
      zio.aws.securityhub.model.AwsRdsDbDomainMembership(
        domain.map(value => value),
        status.map(value => value),
        fqdn.map(value => value),
        iamRoleName.map(value => value)
      )
    def domain: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def fqdn: Option[NonEmptyString]
    def iamRoleName: Option[NonEmptyString]
    def getDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domain", domain)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getFqdn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fqdn", fqdn)
    def getIamRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamRoleName", iamRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership
  ) extends zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly {
    override val domain: Option[NonEmptyString] = scala
      .Option(impl.domain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fqdn: Option[NonEmptyString] = scala
      .Option(impl.fqdn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamRoleName: Option[NonEmptyString] = scala
      .Option(impl.iamRoleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership
  ): zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly = new Wrapper(
    impl
  )
}
