package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterDetails(
    allocatedStorage: Option[Integer] = None,
    availabilityZones: Option[Iterable[NonEmptyString]] = None,
    backupRetentionPeriod: Option[Integer] = None,
    databaseName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    endpoint: Option[NonEmptyString] = None,
    readerEndpoint: Option[NonEmptyString] = None,
    customEndpoints: Option[Iterable[NonEmptyString]] = None,
    multiAz: Option[Boolean] = None,
    engine: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    port: Option[Integer] = None,
    masterUsername: Option[NonEmptyString] = None,
    preferredBackupWindow: Option[NonEmptyString] = None,
    preferredMaintenanceWindow: Option[NonEmptyString] = None,
    readReplicaIdentifiers: Option[Iterable[NonEmptyString]] = None,
    vpcSecurityGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup]
    ] = None,
    hostedZoneId: Option[NonEmptyString] = None,
    storageEncrypted: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    dbClusterResourceId: Option[NonEmptyString] = None,
    associatedRoles: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole]
    ] = None,
    clusterCreateTime: Option[NonEmptyString] = None,
    enabledCloudWatchLogsExports: Option[Iterable[NonEmptyString]] = None,
    engineMode: Option[NonEmptyString] = None,
    deletionProtection: Option[Boolean] = None,
    httpEndpointEnabled: Option[Boolean] = None,
    activityStreamStatus: Option[NonEmptyString] = None,
    copyTagsToSnapshot: Option[Boolean] = None,
    crossAccountClone: Option[Boolean] = None,
    domainMemberships: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbDomainMembership]
    ] = None,
    dbClusterParameterGroup: Option[NonEmptyString] = None,
    dbSubnetGroup: Option[NonEmptyString] = None,
    dbClusterOptionGroupMemberships: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership]
    ] = None,
    dbClusterIdentifier: Option[NonEmptyString] = None,
    dbClusterMembers: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbClusterMember]
    ] = None,
    iamDatabaseAuthenticationEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails = {
    import AwsRdsDbClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
      .builder()
      .optionallyWith(
        allocatedStorage.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.allocatedStorage)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        backupRetentionPeriod.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.backupRetentionPeriod)
      .optionallyWith(
        databaseName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.databaseName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        readerEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.readerEndpoint)
      .optionallyWith(
        customEndpoints.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customEndpoints)
      .optionallyWith(multiAz.map(value => value: java.lang.Boolean))(_.multiAz)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        preferredBackupWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredBackupWindow)
      .optionallyWith(
        preferredMaintenanceWindow.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        readReplicaIdentifiers.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaIdentifiers)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        hostedZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hostedZoneId)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dbClusterResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterResourceId)
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        enabledCloudWatchLogsExports.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudWatchLogsExports)
      .optionallyWith(
        engineMode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engineMode)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        httpEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.httpEndpointEnabled)
      .optionallyWith(
        activityStreamStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.activityStreamStatus)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(
        _.crossAccountClone
      )
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        dbClusterParameterGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterParameterGroup)
      .optionallyWith(
        dbSubnetGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSubnetGroup)
      .optionallyWith(
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterOptionGroupMemberships)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterMembers)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterDetails.wrap(buildAwsValue())
}
object AwsRdsDbClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterDetails =
      zio.aws.securityhub.model.AwsRdsDbClusterDetails(
        allocatedStorage.map(value => value),
        availabilityZones.map(value => value),
        backupRetentionPeriod.map(value => value),
        databaseName.map(value => value),
        status.map(value => value),
        endpoint.map(value => value),
        readerEndpoint.map(value => value),
        customEndpoints.map(value => value),
        multiAz.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        port.map(value => value),
        masterUsername.map(value => value),
        preferredBackupWindow.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        readReplicaIdentifiers.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostedZoneId.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterResourceId.map(value => value),
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clusterCreateTime.map(value => value),
        enabledCloudWatchLogsExports.map(value => value),
        engineMode.map(value => value),
        deletionProtection.map(value => value),
        httpEndpointEnabled.map(value => value),
        activityStreamStatus.map(value => value),
        copyTagsToSnapshot.map(value => value),
        crossAccountClone.map(value => value),
        domainMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterParameterGroup.map(value => value),
        dbSubnetGroup.map(value => value),
        dbClusterOptionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbClusterIdentifier.map(value => value),
        dbClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iamDatabaseAuthenticationEnabled.map(value => value)
      )
    def allocatedStorage: Option[Integer]
    def availabilityZones: Option[List[NonEmptyString]]
    def backupRetentionPeriod: Option[Integer]
    def databaseName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def endpoint: Option[NonEmptyString]
    def readerEndpoint: Option[NonEmptyString]
    def customEndpoints: Option[List[NonEmptyString]]
    def multiAz: Option[Boolean]
    def engine: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def port: Option[Integer]
    def masterUsername: Option[NonEmptyString]
    def preferredBackupWindow: Option[NonEmptyString]
    def preferredMaintenanceWindow: Option[NonEmptyString]
    def readReplicaIdentifiers: Option[List[NonEmptyString]]
    def vpcSecurityGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ]
    def hostedZoneId: Option[NonEmptyString]
    def storageEncrypted: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def dbClusterResourceId: Option[NonEmptyString]
    def associatedRoles: Option[
      List[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly]
    ]
    def clusterCreateTime: Option[NonEmptyString]
    def enabledCloudWatchLogsExports: Option[List[NonEmptyString]]
    def engineMode: Option[NonEmptyString]
    def deletionProtection: Option[Boolean]
    def httpEndpointEnabled: Option[Boolean]
    def activityStreamStatus: Option[NonEmptyString]
    def copyTagsToSnapshot: Option[Boolean]
    def crossAccountClone: Option[Boolean]
    def domainMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ]
    def dbClusterParameterGroup: Option[NonEmptyString]
    def dbSubnetGroup: Option[NonEmptyString]
    def dbClusterOptionGroupMemberships: Option[List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]]
    def dbClusterIdentifier: Option[NonEmptyString]
    def dbClusterMembers
        : Option[List[zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly]]
    def iamDatabaseAuthenticationEnabled: Option[Boolean]
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDatabaseName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getReaderEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("readerEndpoint", readerEndpoint)
    def getCustomEndpoints: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("customEndpoints", customEndpoints)
    def getMultiAz: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAz", multiAz)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getPreferredBackupWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getReadReplicaIdentifiers: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readReplicaIdentifiers",
        readReplicaIdentifiers
      )
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getHostedZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceId)
    def getAssociatedRoles: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedRoles", associatedRoles)
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getEnabledCloudWatchLogsExports
        : ZIO[Any, AwsError, List[NonEmptyString]] = AwsError.unwrapOptionField(
      "enabledCloudWatchLogsExports",
      enabledCloudWatchLogsExports
    )
    def getEngineMode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getDeletionProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getHttpEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("httpEndpointEnabled", httpEndpointEnabled)
    def getActivityStreamStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatus)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getCrossAccountClone: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("crossAccountClone", crossAccountClone)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getDbClusterParameterGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroup",
        dbClusterParameterGroup
      )
    def getDbSubnetGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getDbClusterOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterOptionGroupMemberships",
      dbClusterOptionGroupMemberships
    )
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembers)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly {
    override val allocatedStorage: Option[Integer] = scala
      .Option(impl.allocatedStorage())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val availabilityZones: Option[List[NonEmptyString]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val backupRetentionPeriod: Option[Integer] = scala
      .Option(impl.backupRetentionPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val databaseName: Option[NonEmptyString] = scala
      .Option(impl.databaseName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Option[NonEmptyString] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readerEndpoint: Option[NonEmptyString] = scala
      .Option(impl.readerEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val customEndpoints: Option[List[NonEmptyString]] = scala
      .Option(impl.customEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val multiAz: Option[Boolean] =
      scala.Option(impl.multiAz()).map(value => value: Boolean)
    override val engine: Option[NonEmptyString] = scala
      .Option(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val preferredBackupWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredBackupWindow())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val preferredMaintenanceWindow: Option[NonEmptyString] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val readReplicaIdentifiers: Option[List[NonEmptyString]] = scala
      .Option(impl.readReplicaIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vpcSecurityGroups: Option[
      List[zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.ReadOnly]
    ] = scala
      .Option(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.wrap(item)
        }.toList
      )
    override val hostedZoneId: Option[NonEmptyString] = scala
      .Option(impl.hostedZoneId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterResourceId: Option[NonEmptyString] = scala
      .Option(impl.dbClusterResourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val associatedRoles: Option[
      List[zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.ReadOnly]
    ] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterAssociatedRole.wrap(item)
        }.toList
      )
    override val clusterCreateTime: Option[NonEmptyString] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabledCloudWatchLogsExports: Option[List[NonEmptyString]] =
      scala
        .Option(impl.enabledCloudWatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val engineMode: Option[NonEmptyString] = scala
      .Option(impl.engineMode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deletionProtection: Option[Boolean] =
      scala.Option(impl.deletionProtection()).map(value => value: Boolean)
    override val httpEndpointEnabled: Option[Boolean] =
      scala.Option(impl.httpEndpointEnabled()).map(value => value: Boolean)
    override val activityStreamStatus: Option[NonEmptyString] = scala
      .Option(impl.activityStreamStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val copyTagsToSnapshot: Option[Boolean] =
      scala.Option(impl.copyTagsToSnapshot()).map(value => value: Boolean)
    override val crossAccountClone: Option[Boolean] =
      scala.Option(impl.crossAccountClone()).map(value => value: Boolean)
    override val domainMemberships: Option[
      List[zio.aws.securityhub.model.AwsRdsDbDomainMembership.ReadOnly]
    ] = scala
      .Option(impl.domainMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbDomainMembership.wrap(item)
        }.toList
      )
    override val dbClusterParameterGroup: Option[NonEmptyString] = scala
      .Option(impl.dbClusterParameterGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbSubnetGroup: Option[NonEmptyString] = scala
      .Option(impl.dbSubnetGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterOptionGroupMemberships: Option[List[
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly
    ]] = scala
      .Option(impl.dbClusterOptionGroupMemberships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership
            .wrap(item)
        }.toList
      )
    override val dbClusterIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbClusterIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterMembers: Option[
      List[zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly]
    ] = scala
      .Option(impl.dbClusterMembers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbClusterMember.wrap(item)
        }.toList
      )
    override val iamDatabaseAuthenticationEnabled: Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterDetails
  ): zio.aws.securityhub.model.AwsRdsDbClusterDetails.ReadOnly = new Wrapper(
    impl
  )
}
