package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainVpcOptionsDetails(
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetIds: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails = {
    import AwsOpenSearchServiceDomainVpcOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainVpcOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails =
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails(
        securityGroupIds.map(value => value),
        subnetIds.map(value => value)
      )
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetIds: Option[List[NonEmptyString]]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly {
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetIds: Option[List[NonEmptyString]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
