package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainDetails(
    arn: Option[NonEmptyString] = None,
    accessPolicies: Option[NonEmptyString] = None,
    domainName: Option[NonEmptyString] = None,
    id: Option[NonEmptyString] = None,
    domainEndpoint: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
    ] = None,
    serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
    ] = None,
    clusterConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
    ] = None,
    domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
    ] = None,
    vpcOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
    ] = None,
    logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
    ] = None,
    domainEndpoints: Option[Map[NonEmptyString, NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails = {
    import AwsOpenSearchServiceDomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accessPolicies.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        domainEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.domainEndpoint)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(clusterConfig.map(value => value.buildAwsValue()))(
        _.clusterConfig
      )
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        domainEndpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.domainEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails =
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails(
        arn.map(value => value),
        accessPolicies.map(value => value),
        domainName.map(value => value),
        id.map(value => value),
        domainEndpoint.map(value => value),
        engineVersion.map(value => value),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        serviceSoftwareOptions.map(value => value.asEditable),
        clusterConfig.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        domainEndpoints.map(value => value)
      )
    def arn: Option[NonEmptyString]
    def accessPolicies: Option[NonEmptyString]
    def domainName: Option[NonEmptyString]
    def id: Option[NonEmptyString]
    def domainEndpoint: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ]
    def serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ]
    def clusterConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ]
    def domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ]
    def vpcOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ]
    def logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ]
    def domainEndpoints: Option[Map[NonEmptyString, NonEmptyString]]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccessPolicies: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getDomainEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainEndpoint", domainEndpoint)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("clusterConfig", clusterConfig)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpoints
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("domainEndpoints", domainEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accessPolicies: Option[NonEmptyString] = scala
      .Option(impl.accessPolicies())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainEndpoint: Option[NonEmptyString] = scala
      .Option(impl.domainEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails
          .wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails
          .wrap(value)
      )
    override val serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.serviceSoftwareOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails
          .wrap(value)
      )
    override val clusterConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly
    ] = scala
      .Option(impl.clusterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
          .wrap(value)
      )
    override val domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails
          .wrap(value)
      )
    override val vpcOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.vpcOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails
          .wrap(value)
      )
    override val logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails
          .wrap(value)
      )
    override val domainEndpoints: Option[Map[NonEmptyString, NonEmptyString]] =
      scala
        .Option(impl.domainEndpoints())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainDetails.ReadOnly =
    new Wrapper(impl)
}
