package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsOpenSearchServiceDomainClusterConfigDetails(
    instanceCount: Option[Integer] = None,
    warmEnabled: Option[Boolean] = None,
    warmCount: Option[Integer] = None,
    dedicatedMasterEnabled: Option[Boolean] = None,
    zoneAwarenessConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
    ] = None,
    dedicatedMasterCount: Option[Integer] = None,
    instanceType: Option[NonEmptyString] = None,
    warmType: Option[NonEmptyString] = None,
    zoneAwarenessEnabled: Option[Boolean] = None,
    dedicatedMasterType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = {
    import AwsOpenSearchServiceDomainClusterConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
      .builder()
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(
        warmCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.warmCount)
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(
        dedicatedMasterCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.dedicatedMasterCount)
      .optionallyWith(
        instanceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceType)
      .optionallyWith(
        warmType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.warmType)
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .optionallyWith(
        dedicatedMasterType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dedicatedMasterType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
      .wrap(buildAwsValue())
}
object AwsOpenSearchServiceDomainClusterConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails =
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails(
        instanceCount.map(value => value),
        warmEnabled.map(value => value),
        warmCount.map(value => value),
        dedicatedMasterEnabled.map(value => value),
        zoneAwarenessConfig.map(value => value.asEditable),
        dedicatedMasterCount.map(value => value),
        instanceType.map(value => value),
        warmType.map(value => value),
        zoneAwarenessEnabled.map(value => value),
        dedicatedMasterType.map(value => value)
      )
    def instanceCount: Option[Integer]
    def warmEnabled: Option[Boolean]
    def warmCount: Option[Integer]
    def dedicatedMasterEnabled: Option[Boolean]
    def zoneAwarenessConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ]
    def dedicatedMasterCount: Option[Integer]
    def instanceType: Option[NonEmptyString]
    def warmType: Option[NonEmptyString]
    def zoneAwarenessEnabled: Option[Boolean]
    def dedicatedMasterType: Option[NonEmptyString]
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getWarmCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("warmCount", warmCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getDedicatedMasterCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getInstanceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getWarmType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("warmType", warmType)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
    def getDedicatedMasterType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ) extends zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly {
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val warmEnabled: Option[Boolean] =
      scala.Option(impl.warmEnabled()).map(value => value: Boolean)
    override val warmCount: Option[Integer] = scala
      .Option(impl.warmCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val dedicatedMasterEnabled: Option[Boolean] =
      scala.Option(impl.dedicatedMasterEnabled()).map(value => value: Boolean)
    override val zoneAwarenessConfig: Option[
      zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.ReadOnly
    ] = scala
      .Option(impl.zoneAwarenessConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails
          .wrap(value)
      )
    override val dedicatedMasterCount: Option[Integer] = scala
      .Option(impl.dedicatedMasterCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val instanceType: Option[NonEmptyString] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val warmType: Option[NonEmptyString] = scala
      .Option(impl.warmType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val zoneAwarenessEnabled: Option[Boolean] =
      scala.Option(impl.zoneAwarenessEnabled()).map(value => value: Boolean)
    override val dedicatedMasterType: Option[NonEmptyString] = scala
      .Option(impl.dedicatedMasterType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails
  ): zio.aws.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.ReadOnly =
    new Wrapper(impl)
}
