package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamUserPolicy(policyName: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy = {
    import AwsIamUserPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsIamUserPolicy.wrap(buildAwsValue())
}
object AwsIamUserPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamUserPolicy =
      zio.aws.securityhub.model.AwsIamUserPolicy(policyName.map(value => value))
    def policyName: Option[NonEmptyString]
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ) extends zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly {
    override val policyName: Option[NonEmptyString] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamUserPolicy
  ): zio.aws.securityhub.model.AwsIamUserPolicy.ReadOnly = new Wrapper(impl)
}
