package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamPolicyDetails(
    attachmentCount: Option[Integer] = None,
    createDate: Option[NonEmptyString] = None,
    defaultVersionId: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    isAttachable: Option[Boolean] = None,
    path: Option[NonEmptyString] = None,
    permissionsBoundaryUsageCount: Option[Integer] = None,
    policyId: Option[NonEmptyString] = None,
    policyName: Option[NonEmptyString] = None,
    policyVersionList: Option[
      Iterable[zio.aws.securityhub.model.AwsIamPolicyVersion]
    ] = None,
    updateDate: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails = {
    import AwsIamPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
      .builder()
      .optionallyWith(
        attachmentCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.attachmentCount)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        defaultVersionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultVersionId)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(isAttachable.map(value => value: java.lang.Boolean))(
        _.isAttachable
      )
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        permissionsBoundaryUsageCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.permissionsBoundaryUsageCount)
      .optionallyWith(
        policyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyVersionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyVersionList)
      .optionallyWith(
        updateDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.updateDate)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamPolicyDetails.wrap(buildAwsValue())
}
object AwsIamPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamPolicyDetails =
      zio.aws.securityhub.model.AwsIamPolicyDetails(
        attachmentCount.map(value => value),
        createDate.map(value => value),
        defaultVersionId.map(value => value),
        description.map(value => value),
        isAttachable.map(value => value),
        path.map(value => value),
        permissionsBoundaryUsageCount.map(value => value),
        policyId.map(value => value),
        policyName.map(value => value),
        policyVersionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updateDate.map(value => value)
      )
    def attachmentCount: Option[Integer]
    def createDate: Option[NonEmptyString]
    def defaultVersionId: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def isAttachable: Option[Boolean]
    def path: Option[NonEmptyString]
    def permissionsBoundaryUsageCount: Option[Integer]
    def policyId: Option[NonEmptyString]
    def policyName: Option[NonEmptyString]
    def policyVersionList
        : Option[List[zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly]]
    def updateDate: Option[NonEmptyString]
    def getAttachmentCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("attachmentCount", attachmentCount)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDefaultVersionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultVersionId", defaultVersionId)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getIsAttachable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttachable", isAttachable)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getPermissionsBoundaryUsageCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "permissionsBoundaryUsageCount",
        permissionsBoundaryUsageCount
      )
    def getPolicyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyVersionList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("policyVersionList", policyVersionList)
    def getUpdateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updateDate", updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ) extends zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly {
    override val attachmentCount: Option[Integer] = scala
      .Option(impl.attachmentCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val createDate: Option[NonEmptyString] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultVersionId: Option[NonEmptyString] = scala
      .Option(impl.defaultVersionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isAttachable: Option[Boolean] =
      scala.Option(impl.isAttachable()).map(value => value: Boolean)
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissionsBoundaryUsageCount: Option[Integer] = scala
      .Option(impl.permissionsBoundaryUsageCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val policyId: Option[NonEmptyString] = scala
      .Option(impl.policyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyName: Option[NonEmptyString] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policyVersionList
        : Option[List[zio.aws.securityhub.model.AwsIamPolicyVersion.ReadOnly]] =
      scala
        .Option(impl.policyVersionList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsIamPolicyVersion.wrap(item)
          }.toList
        )
    override val updateDate: Option[NonEmptyString] = scala
      .Option(impl.updateDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPolicyDetails
  ): zio.aws.securityhub.model.AwsIamPolicyDetails.ReadOnly = new Wrapper(impl)
}
