package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerPolicies(
    appCookieStickinessPolicies: Option[
      Iterable[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy]
    ] = None,
    lbCookieStickinessPolicies: Option[
      Iterable[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy]
    ] = None,
    otherPolicies: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies = {
    import AwsElbLoadBalancerPolicies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
      .builder()
      .optionallyWith(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appCookieStickinessPolicies)
      .optionallyWith(
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lbCookieStickinessPolicies)
      .optionallyWith(
        otherPolicies.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.otherPolicies)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.wrap(buildAwsValue())
}
object AwsElbLoadBalancerPolicies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerPolicies =
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        otherPolicies.map(value => value)
      )
    def appCookieStickinessPolicies: Option[
      List[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly]
    ]
    def lbCookieStickinessPolicies: Option[
      List[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly]
    ]
    def otherPolicies: Option[List[NonEmptyString]]
    def getAppCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appCookieStickinessPolicies",
      appCookieStickinessPolicies
    )
    def getLbCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lbCookieStickinessPolicies",
      lbCookieStickinessPolicies
    )
    def getOtherPolicies: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("otherPolicies", otherPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly {
    override val appCookieStickinessPolicies: Option[
      List[zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.ReadOnly]
    ] = scala
      .Option(impl.appCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbAppCookieStickinessPolicy.wrap(item)
        }.toList
      )
    override val lbCookieStickinessPolicies: Option[
      List[zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly]
    ] = scala
      .Option(impl.lbCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.wrap(item)
        }.toList
      )
    override val otherPolicies: Option[List[NonEmptyString]] = scala
      .Option(impl.otherPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerPolicies
  ): zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly =
    new Wrapper(impl)
}
