package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerHealthCheck(
    healthyThreshold: Option[Integer] = None,
    interval: Option[Integer] = None,
    target: Option[NonEmptyString] = None,
    timeout: Option[Integer] = None,
    unhealthyThreshold: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck = {
    import AwsElbLoadBalancerHealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
      .builder()
      .optionallyWith(
        healthyThreshold.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.healthyThreshold)
      .optionallyWith(
        interval.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.interval)
      .optionallyWith(
        target.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(
        timeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.timeout)
      .optionallyWith(
        unhealthyThreshold.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.unhealthyThreshold)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerHealthCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck =
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck(
        healthyThreshold.map(value => value),
        interval.map(value => value),
        target.map(value => value),
        timeout.map(value => value),
        unhealthyThreshold.map(value => value)
      )
    def healthyThreshold: Option[Integer]
    def interval: Option[Integer]
    def target: Option[NonEmptyString]
    def timeout: Option[Integer]
    def unhealthyThreshold: Option[Integer]
    def getHealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("healthyThreshold", healthyThreshold)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getTarget: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("target", target)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getUnhealthyThreshold: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThreshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly {
    override val healthyThreshold: Option[Integer] = scala
      .Option(impl.healthyThreshold())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val interval: Option[Integer] = scala
      .Option(impl.interval())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val target: Option[NonEmptyString] = scala
      .Option(impl.target())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeout: Option[Integer] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val unhealthyThreshold: Option[Integer] = scala
      .Option(impl.unhealthyThreshold())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerHealthCheck
  ): zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly =
    new Wrapper(impl)
}
