package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerDetails(
    availabilityZones: Option[Iterable[NonEmptyString]] = None,
    backendServerDescriptions: Option[Iterable[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription
    ]] = None,
    canonicalHostedZoneName: Option[NonEmptyString] = None,
    canonicalHostedZoneNameID: Option[NonEmptyString] = None,
    createdTime: Option[NonEmptyString] = None,
    dnsName: Option[NonEmptyString] = None,
    healthCheck: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck
    ] = None,
    instances: Option[
      Iterable[zio.aws.securityhub.model.AwsElbLoadBalancerInstance]
    ] = None,
    listenerDescriptions: Option[
      Iterable[zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription]
    ] = None,
    loadBalancerAttributes: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes
    ] = None,
    loadBalancerName: Option[NonEmptyString] = None,
    policies: Option[zio.aws.securityhub.model.AwsElbLoadBalancerPolicies] =
      None,
    scheme: Option[NonEmptyString] = None,
    securityGroups: Option[Iterable[NonEmptyString]] = None,
    sourceSecurityGroup: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
    ] = None,
    subnets: Option[Iterable[NonEmptyString]] = None,
    vpcId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails = {
    import AwsElbLoadBalancerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backendServerDescriptions)
      .optionallyWith(
        canonicalHostedZoneName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneName)
      .optionallyWith(
        canonicalHostedZoneNameID.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneNameID)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(
        dnsName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(
        listenerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listenerDescriptions)
      .optionallyWith(
        loadBalancerAttributes.map(value => value.buildAwsValue())
      )(_.loadBalancerAttributes)
      .optionallyWith(
        loadBalancerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(
        scheme.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scheme)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceSecurityGroup.map(value => value.buildAwsValue()))(
        _.sourceSecurityGroup
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerDetails.wrap(buildAwsValue())
}
object AwsElbLoadBalancerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLoadBalancerDetails =
      zio.aws.securityhub.model.AwsElbLoadBalancerDetails(
        availabilityZones.map(value => value),
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        canonicalHostedZoneName.map(value => value),
        canonicalHostedZoneNameID.map(value => value),
        createdTime.map(value => value),
        dnsName.map(value => value),
        healthCheck.map(value => value.asEditable),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listenerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        loadBalancerAttributes.map(value => value.asEditable),
        loadBalancerName.map(value => value),
        policies.map(value => value.asEditable),
        scheme.map(value => value),
        securityGroups.map(value => value),
        sourceSecurityGroup.map(value => value.asEditable),
        subnets.map(value => value),
        vpcId.map(value => value)
      )
    def availabilityZones: Option[List[NonEmptyString]]
    def backendServerDescriptions: Option[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]]
    def canonicalHostedZoneName: Option[NonEmptyString]
    def canonicalHostedZoneNameID: Option[NonEmptyString]
    def createdTime: Option[NonEmptyString]
    def dnsName: Option[NonEmptyString]
    def healthCheck: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ]
    def instances: Option[
      List[zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly]
    ]
    def listenerDescriptions: Option[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]]
    def loadBalancerAttributes: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ]
    def loadBalancerName: Option[NonEmptyString]
    def policies
        : Option[zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly]
    def scheme: Option[NonEmptyString]
    def securityGroups: Option[List[NonEmptyString]]
    def sourceSecurityGroup: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ]
    def subnets: Option[List[NonEmptyString]]
    def vpcId: Option[NonEmptyString]
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getBackendServerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backendServerDescriptions",
      backendServerDescriptions
    )
    def getCanonicalHostedZoneName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "canonicalHostedZoneName",
        canonicalHostedZoneName
      )
    def getCanonicalHostedZoneNameID: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "canonicalHostedZoneNameID",
        canonicalHostedZoneNameID
      )
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getListenerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("listenerDescriptions", listenerDescriptions)
    def getLoadBalancerAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "loadBalancerAttributes",
      loadBalancerAttributes
    )
    def getLoadBalancerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getScheme: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scheme", scheme)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("sourceSecurityGroup", sourceSecurityGroup)
    def getSubnets: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly {
    override val availabilityZones: Option[List[NonEmptyString]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val backendServerDescriptions: Option[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription.ReadOnly
    ]] = scala
      .Option(impl.backendServerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerBackendServerDescription
            .wrap(item)
        }.toList
      )
    override val canonicalHostedZoneName: Option[NonEmptyString] = scala
      .Option(impl.canonicalHostedZoneName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val canonicalHostedZoneNameID: Option[NonEmptyString] = scala
      .Option(impl.canonicalHostedZoneNameID())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdTime: Option[NonEmptyString] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dnsName: Option[NonEmptyString] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val healthCheck: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerHealthCheck.wrap(value)
      )
    override val instances: Option[
      List[zio.aws.securityhub.model.AwsElbLoadBalancerInstance.ReadOnly]
    ] = scala
      .Option(impl.instances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerInstance.wrap(item)
        }.toList
      )
    override val listenerDescriptions: Option[List[
      zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription.ReadOnly
    ]] = scala
      .Option(impl.listenerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbLoadBalancerListenerDescription
            .wrap(item)
        }.toList
      )
    override val loadBalancerAttributes: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.ReadOnly
    ] = scala
      .Option(impl.loadBalancerAttributes())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerAttributes.wrap(value)
      )
    override val loadBalancerName: Option[NonEmptyString] = scala
      .Option(impl.loadBalancerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val policies: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.ReadOnly
    ] = scala
      .Option(impl.policies())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerPolicies.wrap(value)
      )
    override val scheme: Option[NonEmptyString] = scala
      .Option(impl.scheme())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val sourceSecurityGroup: Option[
      zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.ReadOnly
    ] = scala
      .Option(impl.sourceSecurityGroup())
      .map(value =>
        zio.aws.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup
          .wrap(value)
      )
    override val subnets: Option[List[NonEmptyString]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerDetails
  ): zio.aws.securityhub.model.AwsElbLoadBalancerDetails.ReadOnly = new Wrapper(
    impl
  )
}
