package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerConnectionSettings(
    idleTimeout: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings = {
    import AwsElbLoadBalancerConnectionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
      .builder()
      .optionallyWith(
        idleTimeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.idleTimeout)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerConnectionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings =
      zio.aws.securityhub.model
        .AwsElbLoadBalancerConnectionSettings(idleTimeout.map(value => value))
    def idleTimeout: Option[Integer]
    def getIdleTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("idleTimeout", idleTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly {
    override val idleTimeout: Option[Integer] = scala
      .Option(impl.idleTimeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ): zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly =
    new Wrapper(impl)
}
