package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainVPCOptions(
    availabilityZones: Option[Iterable[NonEmptyString]] = None,
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetIds: Option[Iterable[NonEmptyString]] = None,
    vpcId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions = {
    import AwsElasticsearchDomainVPCOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainVPCOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions =
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions(
        availabilityZones.map(value => value),
        securityGroupIds.map(value => value),
        subnetIds.map(value => value),
        vpcId.map(value => value)
      )
    def availabilityZones: Option[List[NonEmptyString]]
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetIds: Option[List[NonEmptyString]]
    def vpcId: Option[NonEmptyString]
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly {
    override val availabilityZones: Option[List[NonEmptyString]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetIds: Option[List[NonEmptyString]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly =
    new Wrapper(impl)
}
