package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesDetails(
    dockerVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
    ] = None,
    efsVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
    ] = None,
    host: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
    ] = None,
    name: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails = {
    import AwsEcsTaskDefinitionVolumesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
      .builder()
      .optionallyWith(
        dockerVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.dockerVolumeConfiguration)
      .optionallyWith(
        efsVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.efsVolumeConfiguration)
      .optionallyWith(host.map(value => value.buildAwsValue()))(_.host)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails(
        dockerVolumeConfiguration.map(value => value.asEditable),
        efsVolumeConfiguration.map(value => value.asEditable),
        host.map(value => value.asEditable),
        name.map(value => value)
      )
    def dockerVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ]
    def efsVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ]
    def host: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ]
    def name: Option[NonEmptyString]
    def getDockerVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dockerVolumeConfiguration",
      dockerVolumeConfiguration
    )
    def getEfsVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "efsVolumeConfiguration",
      efsVolumeConfiguration
    )
    def getHost: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ] = AwsError.unwrapOptionField("host", host)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly {
    override val dockerVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.dockerVolumeConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
          .wrap(value)
      )
    override val efsVolumeConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.efsVolumeConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails
          .wrap(value)
      )
    override val host: Option[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails.ReadOnly
    ] = scala
      .Option(impl.host())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesHostDetails
          .wrap(value)
      )
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDetails.ReadOnly =
    new Wrapper(impl)
}
