package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionPlacementConstraintsDetails(
    expression: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails = {
    import AwsEcsTaskDefinitionPlacementConstraintsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
      .builder()
      .optionallyWith(
        expression.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionPlacementConstraintsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails =
      zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails(
        expression.map(value => value),
        `type`.map(value => value)
      )
    def expression: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("expression", expression)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly {
    override val expression: Option[NonEmptyString] = scala
      .Option(impl.expression())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionPlacementConstraintsDetails.ReadOnly =
    new Wrapper(impl)
}
