package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(
    readOnly: Option[Boolean] = None,
    sourceContainer: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
      .builder()
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(
        sourceContainer.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceContainer)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(
          readOnly.map(value => value),
          sourceContainer.map(value => value)
        )
    def readOnly: Option[Boolean]
    def sourceContainer: Option[NonEmptyString]
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getSourceContainer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceContainer", sourceContainer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly {
    override val readOnly: Option[Boolean] =
      scala.Option(impl.readOnly()).map(value => value: Boolean)
    override val sourceContainer: Option[NonEmptyString] = scala
      .Option(impl.sourceContainer())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.ReadOnly =
    new Wrapper(impl)
}
