package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(
    `type`: Option[NonEmptyString] = None,
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(
          `type`.map(value => value),
          value.map(value => value)
        )
    def `type`: Option[NonEmptyString]
    def value: Option[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly {
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.ReadOnly =
    new Wrapper(impl)
}
