package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(
    name: Option[NonEmptyString] = None,
    valueFrom: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        valueFrom.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.valueFrom)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails(
          name.map(value => value),
          valueFrom.map(value => value)
        )
    def name: Option[NonEmptyString]
    def valueFrom: Option[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValueFrom: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("valueFrom", valueFrom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly {
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val valueFrom: Option[NonEmptyString] = scala
      .Option(impl.valueFrom())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
