package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(
    logDriver: Option[NonEmptyString] = None,
    options: Option[Map[NonEmptyString, NonEmptyString]] = None,
    secretOptions: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
      .builder()
      .optionallyWith(
        logDriver.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.logDriver)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .optionallyWith(
        secretOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secretOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(
          logDriver.map(value => value),
          options.map(value => value),
          secretOptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def logDriver: Option[NonEmptyString]
    def options: Option[Map[NonEmptyString, NonEmptyString]]
    def secretOptions: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly
    ]]
    def getLogDriver: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("logDriver", logDriver)
    def getOptions: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("options", options)
    def getSecretOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("secretOptions", secretOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly {
    override val logDriver: Option[NonEmptyString] = scala
      .Option(impl.logDriver())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val options: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val secretOptions: Option[List[
      zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.ReadOnly
    ]] = scala
      .Option(impl.secretOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
