package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(
    command: Option[Iterable[NonEmptyString]] = None,
    interval: Option[Integer] = None,
    retries: Option[Integer] = None,
    startPeriod: Option[Integer] = None,
    timeout: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
      .builder()
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        interval.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.interval)
      .optionallyWith(
        retries.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.retries)
      .optionallyWith(
        startPeriod.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.startPeriod)
      .optionallyWith(
        timeout.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.timeout)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(
          command.map(value => value),
          interval.map(value => value),
          retries.map(value => value),
          startPeriod.map(value => value),
          timeout.map(value => value)
        )
    def command: Option[List[NonEmptyString]]
    def interval: Option[Integer]
    def retries: Option[Integer]
    def startPeriod: Option[Integer]
    def timeout: Option[Integer]
    def getCommand: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("command", command)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getRetries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("retries", retries)
    def getStartPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startPeriod", startPeriod)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly {
    override val command: Option[List[NonEmptyString]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val interval: Option[Integer] = scala
      .Option(impl.interval())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val retries: Option[Integer] = scala
      .Option(impl.retries())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val startPeriod: Option[Integer] = scala
      .Option(impl.startPeriod())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val timeout: Option[Integer] = scala
      .Option(impl.timeout())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.ReadOnly =
    new Wrapper(impl)
}
