package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServicePlacementStrategiesDetails(
    field: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails = {
    import AwsEcsServicePlacementStrategiesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails
      .builder()
      .optionallyWith(
        field.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.field)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails
      .wrap(buildAwsValue())
}
object AwsEcsServicePlacementStrategiesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails =
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails(
        field.map(value => value),
        `type`.map(value => value)
      )
    def field: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getField: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("field", field)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails
  ) extends zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly {
    override val field: Option[NonEmptyString] = scala
      .Option(impl.field())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails
  ): zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly =
    new Wrapper(impl)
}
