package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceNetworkConfigurationDetails(
    awsVpcConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails = {
    import AwsEcsServiceNetworkConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
      .builder()
      .optionallyWith(awsVpcConfiguration.map(value => value.buildAwsValue()))(
        _.awsVpcConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceNetworkConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails =
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails(
        awsVpcConfiguration.map(value => value.asEditable)
      )
    def awsVpcConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly
    ]
    def getAwsVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("awsVpcConfiguration", awsVpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly {
    override val awsVpcConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.awsVpcConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationAwsVpcConfigurationDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
