package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(
    enable: Option[Boolean] = None,
    rollback: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails = {
    import AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
      .builder()
      .optionallyWith(enable.map(value => value: java.lang.Boolean))(_.enable)
      .optionallyWith(rollback.map(value => value: java.lang.Boolean))(
        _.rollback
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails =
      zio.aws.securityhub.model
        .AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails(
          enable.map(value => value),
          rollback.map(value => value)
        )
    def enable: Option[Boolean]
    def rollback: Option[Boolean]
    def getEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enable", enable)
    def getRollback: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rollback", rollback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly {
    override val enable: Option[Boolean] =
      scala.Option(impl.enable()).map(value => value: Boolean)
    override val rollback: Option[Boolean] =
      scala.Option(impl.rollback()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails
  ): zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.ReadOnly =
    new Wrapper(impl)
}
