package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterDefaultCapacityProviderStrategyDetails(
    base: Option[Integer] = None,
    capacityProvider: Option[NonEmptyString] = None,
    weight: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails = {
    import AwsEcsClusterDefaultCapacityProviderStrategyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
      .builder()
      .optionallyWith(
        base.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.base)
      .optionallyWith(
        capacityProvider.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityProvider)
      .optionallyWith(
        weight.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
      .wrap(buildAwsValue())
}
object AwsEcsClusterDefaultCapacityProviderStrategyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails =
      zio.aws.securityhub.model
        .AwsEcsClusterDefaultCapacityProviderStrategyDetails(
          base.map(value => value),
          capacityProvider.map(value => value),
          weight.map(value => value)
        )
    def base: Option[Integer]
    def capacityProvider: Option[NonEmptyString]
    def weight: Option[Integer]
    def getBase: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("base", base)
    def getCapacityProvider: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
    def getWeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly {
    override val base: Option[Integer] = scala
      .Option(impl.base())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val capacityProvider: Option[NonEmptyString] = scala
      .Option(impl.capacityProvider())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val weight: Option[Integer] = scala
      .Option(impl.weight())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
  ): zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly =
    new Wrapper(impl)
}
