package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionVgwTelemetryDetails(
    acceptedRouteCount: Option[Integer] = None,
    certificateArn: Option[NonEmptyString] = None,
    lastStatusChange: Option[NonEmptyString] = None,
    outsideIpAddress: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    statusMessage: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails = {
    import AwsEc2VpnConnectionVgwTelemetryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
      .builder()
      .optionallyWith(
        acceptedRouteCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.acceptedRouteCount)
      .optionallyWith(
        certificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        lastStatusChange.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastStatusChange)
      .optionallyWith(
        outsideIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.outsideIpAddress)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
      .wrap(buildAwsValue())
}
object AwsEc2VpnConnectionVgwTelemetryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails(
        acceptedRouteCount.map(value => value),
        certificateArn.map(value => value),
        lastStatusChange.map(value => value),
        outsideIpAddress.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def acceptedRouteCount: Option[Integer]
    def certificateArn: Option[NonEmptyString]
    def lastStatusChange: Option[NonEmptyString]
    def outsideIpAddress: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def statusMessage: Option[NonEmptyString]
    def getAcceptedRouteCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("acceptedRouteCount", acceptedRouteCount)
    def getCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getLastStatusChange: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getOutsideIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly {
    override val acceptedRouteCount: Option[Integer] = scala
      .Option(impl.acceptedRouteCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val certificateArn: Option[NonEmptyString] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastStatusChange: Option[NonEmptyString] = scala
      .Option(impl.lastStatusChange())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val outsideIpAddress: Option[NonEmptyString] = scala
      .Option(impl.outsideIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statusMessage: Option[NonEmptyString] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly =
    new Wrapper(impl)
}
