package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VpnConnectionDetails(
    vpnConnectionId: Option[NonEmptyString] = None,
    state: Option[NonEmptyString] = None,
    customerGatewayId: Option[NonEmptyString] = None,
    customerGatewayConfiguration: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None,
    vpnGatewayId: Option[NonEmptyString] = None,
    category: Option[NonEmptyString] = None,
    vgwTelemetry: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails]
    ] = None,
    options: Option[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails
    ] = None,
    routes: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails]
    ] = None,
    transitGatewayId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionDetails = {
    import AwsEc2VpnConnectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionDetails
      .builder()
      .optionallyWith(
        vpnConnectionId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpnConnectionId)
      .optionallyWith(
        state.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        customerGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customerGatewayId)
      .optionallyWith(
        customerGatewayConfiguration.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.customerGatewayConfiguration)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vpnGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vpnGatewayId)
      .optionallyWith(
        category.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        vgwTelemetry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vgwTelemetry)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        routes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routes)
      .optionallyWith(
        transitGatewayId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.wrap(buildAwsValue())
}
object AwsEc2VpnConnectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VpnConnectionDetails =
      zio.aws.securityhub.model.AwsEc2VpnConnectionDetails(
        vpnConnectionId.map(value => value),
        state.map(value => value),
        customerGatewayId.map(value => value),
        customerGatewayConfiguration.map(value => value),
        `type`.map(value => value),
        vpnGatewayId.map(value => value),
        category.map(value => value),
        vgwTelemetry.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        options.map(value => value.asEditable),
        routes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transitGatewayId.map(value => value)
      )
    def vpnConnectionId: Option[NonEmptyString]
    def state: Option[NonEmptyString]
    def customerGatewayId: Option[NonEmptyString]
    def customerGatewayConfiguration: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def vpnGatewayId: Option[NonEmptyString]
    def category: Option[NonEmptyString]
    def vgwTelemetry: Option[List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly
    ]]
    def options: Option[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly
    ]
    def routes: Option[
      List[zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly]
    ]
    def transitGatewayId: Option[NonEmptyString]
    def getVpnConnectionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpnConnectionId", vpnConnectionId)
    def getState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("state", state)
    def getCustomerGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getCustomerGatewayConfiguration: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "customerGatewayConfiguration",
        customerGatewayConfiguration
      )
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpnGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getCategory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("category", category)
    def getVgwTelemetry: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("vgwTelemetry", vgwTelemetry)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getRoutes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("routes", routes)
    def getTransitGatewayId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionDetails
  ) extends zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly {
    override val vpnConnectionId: Option[NonEmptyString] = scala
      .Option(impl.vpnConnectionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val state: Option[NonEmptyString] = scala
      .Option(impl.state())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val customerGatewayId: Option[NonEmptyString] = scala
      .Option(impl.customerGatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val customerGatewayConfiguration: Option[NonEmptyString] = scala
      .Option(impl.customerGatewayConfiguration())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpnGatewayId: Option[NonEmptyString] = scala
      .Option(impl.vpnGatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val category: Option[NonEmptyString] = scala
      .Option(impl.category())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vgwTelemetry: Option[List[
      zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails.ReadOnly
    ]] = scala
      .Option(impl.vgwTelemetry())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VpnConnectionVgwTelemetryDetails
            .wrap(item)
        }.toList
      )
    override val options: Option[
      zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2VpnConnectionOptionsDetails.wrap(value)
      )
    override val routes: Option[
      List[zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.ReadOnly]
    ] = scala
      .Option(impl.routes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VpnConnectionRoutesDetails.wrap(item)
        }.toList
      )
    override val transitGatewayId: Option[NonEmptyString] = scala
      .Option(impl.transitGatewayId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VpnConnectionDetails
  ): zio.aws.securityhub.model.AwsEc2VpnConnectionDetails.ReadOnly =
    new Wrapper(impl)
}
