package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VolumeAttachment(
    attachTime: Option[NonEmptyString] = None,
    deleteOnTermination: Option[Boolean] = None,
    instanceId: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment = {
    import AwsEc2VolumeAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
      .builder()
      .optionallyWith(
        attachTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.attachTime)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VolumeAttachment.wrap(buildAwsValue())
}
object AwsEc2VolumeAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VolumeAttachment =
      zio.aws.securityhub.model.AwsEc2VolumeAttachment(
        attachTime.map(value => value),
        deleteOnTermination.map(value => value),
        instanceId.map(value => value),
        status.map(value => value)
      )
    def attachTime: Option[NonEmptyString]
    def deleteOnTermination: Option[Boolean]
    def instanceId: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getAttachTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ) extends zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly {
    override val attachTime: Option[NonEmptyString] = scala
      .Option(impl.attachTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val instanceId: Option[NonEmptyString] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeAttachment
  ): zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly = new Wrapper(
    impl
  )
}
