package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupIpPermission(
    ipProtocol: Option[NonEmptyString] = None,
    fromPort: Option[Integer] = None,
    toPort: Option[Integer] = None,
    userIdGroupPairs: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair]
    ] = None,
    ipRanges: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange]
    ] = None,
    ipv6Ranges: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range]
    ] = None,
    prefixListIds: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission = {
    import AwsEc2SecurityGroupIpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
      .builder()
      .optionallyWith(
        ipProtocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ipProtocol)
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        ipv6Ranges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Ranges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission
      .wrap(buildAwsValue())
}
object AwsEc2SecurityGroupIpPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission =
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission(
        ipProtocol.map(value => value),
        fromPort.map(value => value),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Ranges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ipProtocol: Option[NonEmptyString]
    def fromPort: Option[Integer]
    def toPort: Option[Integer]
    def userIdGroupPairs: Option[List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]]
    def ipRanges: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly]
    ]
    def ipv6Ranges: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly]
    ]
    def prefixListIds: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly]
    ]
    def getIpProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]] = AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
    def getIpRanges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly
    ]] = AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getIpv6Ranges: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Ranges", ipv6Ranges)
    def getPrefixListIds: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly
    ]] = AwsError.unwrapOptionField("prefixListIds", prefixListIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly {
    override val ipProtocol: Option[NonEmptyString] = scala
      .Option(impl.ipProtocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val userIdGroupPairs: Option[List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair.ReadOnly
    ]] = scala
      .Option(impl.userIdGroupPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupUserIdGroupPair
            .wrap(item)
        }.toList
      )
    override val ipRanges: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.ReadOnly]
    ] = scala
      .Option(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpRange.wrap(item)
        }.toList
      )
    override val ipv6Ranges: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.ReadOnly]
    ] = scala
      .Option(impl.ipv6Ranges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpv6Range.wrap(item)
        }.toList
      )
    override val prefixListIds: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.ReadOnly]
    ] = scala
      .Option(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupPrefixListId.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupIpPermission
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly =
    new Wrapper(impl)
}
