package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2SecurityGroupDetails(
    groupName: Option[NonEmptyString] = None,
    groupId: Option[NonEmptyString] = None,
    ownerId: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    ipPermissions: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission]
    ] = None,
    ipPermissionsEgress: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails = {
    import AwsEc2SecurityGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        ipPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissions)
      .optionallyWith(
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipPermissionsEgress)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.wrap(buildAwsValue())
}
object AwsEc2SecurityGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2SecurityGroupDetails =
      zio.aws.securityhub.model.AwsEc2SecurityGroupDetails(
        groupName.map(value => value),
        groupId.map(value => value),
        ownerId.map(value => value),
        vpcId.map(value => value),
        ipPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupName: Option[NonEmptyString]
    def groupId: Option[NonEmptyString]
    def ownerId: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def ipPermissions: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ]
    def ipPermissionsEgress: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getIpPermissions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("ipPermissions", ipPermissions)
    def getIpPermissionsEgress: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("ipPermissionsEgress", ipPermissionsEgress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ) extends zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly {
    override val groupName: Option[NonEmptyString] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val groupId: Option[NonEmptyString] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerId: Option[NonEmptyString] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipPermissions: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ] = scala
      .Option(impl.ipPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.wrap(item)
        }.toList
      )
    override val ipPermissionsEgress: Option[
      List[zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.ReadOnly]
    ] = scala
      .Option(impl.ipPermissionsEgress())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2SecurityGroupIpPermission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2SecurityGroupDetails
  ): zio.aws.securityhub.model.AwsEc2SecurityGroupDetails.ReadOnly =
    new Wrapper(impl)
}
