package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfacePrivateIpAddressDetail(
    privateIpAddress: Option[NonEmptyString] = None,
    privateDnsName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail = {
    import AwsEc2NetworkInterfacePrivateIpAddressDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
      .builder()
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .optionallyWith(
        privateDnsName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateDnsName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfacePrivateIpAddressDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail =
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail(
        privateIpAddress.map(value => value),
        privateDnsName.map(value => value)
      )
    def privateIpAddress: Option[NonEmptyString]
    def privateDnsName: Option[NonEmptyString]
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly {
    override val privateIpAddress: Option[NonEmptyString] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val privateDnsName: Option[NonEmptyString] = scala
      .Option(impl.privateDnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly =
    new Wrapper(impl)
}
