package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableProvisionedThroughputOverride(
    readCapacityUnits: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride = {
    import AwsDynamoDbTableProvisionedThroughputOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
      .builder()
      .optionallyWith(
        readCapacityUnits.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.readCapacityUnits)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableProvisionedThroughputOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride =
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride(
        readCapacityUnits.map(value => value)
      )
    def readCapacityUnits: Option[Integer]
    def getReadCapacityUnits: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("readCapacityUnits", readCapacityUnits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly {
    override val readCapacityUnits: Option[Integer] = scala
      .Option(impl.readCapacityUnits())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride
  ): zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughputOverride.ReadOnly =
    new Wrapper(impl)
}
