package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableLocalSecondaryIndex(
    indexArn: Option[NonEmptyString] = None,
    indexName: Option[NonEmptyString] = None,
    keySchema: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
    ] = None,
    projection: Option[zio.aws.securityhub.model.AwsDynamoDbTableProjection] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex = {
    import AwsDynamoDbTableLocalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
      .builder()
      .optionallyWith(
        indexArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexArn)
      .optionallyWith(
        indexName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableLocalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex =
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex(
        indexArn.map(value => value),
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable)
      )
    def indexArn: Option[NonEmptyString]
    def indexName: Option[NonEmptyString]
    def keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ]
    def projection
        : Option[zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly]
    def getIndexArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexArn", indexArn)
    def getIndexName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = AwsError.unwrapOptionField("projection", projection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly {
    override val indexArn: Option[NonEmptyString] = scala
      .Option(impl.indexArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val indexName: Option[NonEmptyString] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(item)
        }.toList
      )
    override val projection: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = scala
      .Option(impl.projection())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProjection.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ): zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly =
    new Wrapper(impl)
}
