package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, SizeBytes, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableGlobalSecondaryIndex(
    backfilling: Option[Boolean] = None,
    indexArn: Option[NonEmptyString] = None,
    indexName: Option[NonEmptyString] = None,
    indexSizeBytes: Option[SizeBytes] = None,
    indexStatus: Option[NonEmptyString] = None,
    itemCount: Option[Integer] = None,
    keySchema: Option[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
    ] = None,
    projection: Option[zio.aws.securityhub.model.AwsDynamoDbTableProjection] =
      None,
    provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex = {
    import AwsDynamoDbTableGlobalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
      .builder()
      .optionallyWith(backfilling.map(value => value: java.lang.Boolean))(
        _.backfilling
      )
      .optionallyWith(
        indexArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexArn)
      .optionallyWith(
        indexName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        indexSizeBytes.map(value => SizeBytes.unwrap(value): java.lang.Long)
      )(_.indexSizeBytes)
      .optionallyWith(
        indexStatus.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexStatus)
      .optionallyWith(
        itemCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.itemCount)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableGlobalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex =
      zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex(
        backfilling.map(value => value),
        indexArn.map(value => value),
        indexName.map(value => value),
        indexSizeBytes.map(value => value),
        indexStatus.map(value => value),
        itemCount.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable),
        provisionedThroughput.map(value => value.asEditable)
      )
    def backfilling: Option[Boolean]
    def indexArn: Option[NonEmptyString]
    def indexName: Option[NonEmptyString]
    def indexSizeBytes: Option[SizeBytes]
    def indexStatus: Option[NonEmptyString]
    def itemCount: Option[Integer]
    def keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ]
    def projection
        : Option[zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly]
    def provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ]
    def getBackfilling: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("backfilling", backfilling)
    def getIndexArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexArn", indexArn)
    def getIndexName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getIndexSizeBytes: ZIO[Any, AwsError, SizeBytes] =
      AwsError.unwrapOptionField("indexSizeBytes", indexSizeBytes)
    def getIndexStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexStatus", indexStatus)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = AwsError.unwrapOptionField("projection", projection)
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly {
    override val backfilling: Option[Boolean] =
      scala.Option(impl.backfilling()).map(value => value: Boolean)
    override val indexArn: Option[NonEmptyString] = scala
      .Option(impl.indexArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val indexName: Option[NonEmptyString] = scala
      .Option(impl.indexName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val indexSizeBytes: Option[SizeBytes] = scala
      .Option(impl.indexSizeBytes())
      .map(value => zio.aws.securityhub.model.primitives.SizeBytes(value))
    override val indexStatus: Option[NonEmptyString] = scala
      .Option(impl.indexStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val itemCount: Option[Integer] = scala
      .Option(impl.itemCount())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val keySchema: Option[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(item)
        }.toList
      )
    override val projection: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = scala
      .Option(impl.projection())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProjection.wrap(value)
      )
    override val provisionedThroughput: Option[
      zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput.ReadOnly
    ] = scala
      .Option(impl.provisionedThroughput())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProvisionedThroughput
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex
  ): zio.aws.securityhub.model.AwsDynamoDbTableGlobalSecondaryIndex.ReadOnly =
    new Wrapper(impl)
}
