package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCorsConfiguration(
    allowOrigins: Option[Iterable[NonEmptyString]] = None,
    allowCredentials: Option[Boolean] = None,
    exposeHeaders: Option[Iterable[NonEmptyString]] = None,
    maxAge: Option[Integer] = None,
    allowMethods: Option[Iterable[NonEmptyString]] = None,
    allowHeaders: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCorsConfiguration = {
    import AwsCorsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCorsConfiguration
      .builder()
      .optionallyWith(
        allowOrigins.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowOrigins)
      .optionallyWith(allowCredentials.map(value => value: java.lang.Boolean))(
        _.allowCredentials
      )
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .optionallyWith(
        maxAge.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxAge)
      .optionallyWith(
        allowMethods.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowMethods)
      .optionallyWith(
        allowHeaders.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowHeaders)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly =
    zio.aws.securityhub.model.AwsCorsConfiguration.wrap(buildAwsValue())
}
object AwsCorsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCorsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCorsConfiguration =
      zio.aws.securityhub.model.AwsCorsConfiguration(
        allowOrigins.map(value => value),
        allowCredentials.map(value => value),
        exposeHeaders.map(value => value),
        maxAge.map(value => value),
        allowMethods.map(value => value),
        allowHeaders.map(value => value)
      )
    def allowOrigins: Option[List[NonEmptyString]]
    def allowCredentials: Option[Boolean]
    def exposeHeaders: Option[List[NonEmptyString]]
    def maxAge: Option[Integer]
    def allowMethods: Option[List[NonEmptyString]]
    def allowHeaders: Option[List[NonEmptyString]]
    def getAllowOrigins: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("allowOrigins", allowOrigins)
    def getAllowCredentials: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowCredentials", allowCredentials)
    def getExposeHeaders: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeaders)
    def getMaxAge: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxAge", maxAge)
    def getAllowMethods: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("allowMethods", allowMethods)
    def getAllowHeaders: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("allowHeaders", allowHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCorsConfiguration
  ) extends zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly {
    override val allowOrigins: Option[List[NonEmptyString]] = scala
      .Option(impl.allowOrigins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val allowCredentials: Option[Boolean] =
      scala.Option(impl.allowCredentials()).map(value => value: Boolean)
    override val exposeHeaders: Option[List[NonEmptyString]] = scala
      .Option(impl.exposeHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val maxAge: Option[Integer] = scala
      .Option(impl.maxAge())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val allowMethods: Option[List[NonEmptyString]] = scala
      .Option(impl.allowMethods())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val allowHeaders: Option[List[NonEmptyString]] = scala
      .Option(impl.allowHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCorsConfiguration
  ): zio.aws.securityhub.model.AwsCorsConfiguration.ReadOnly = new Wrapper(impl)
}
