package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectSource(
    `type`: Option[NonEmptyString] = None,
    location: Option[NonEmptyString] = None,
    gitCloneDepth: Option[Integer] = None,
    insecureSsl: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource = {
    import AwsCodeBuildProjectSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        location.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        gitCloneDepth.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.gitCloneDepth)
      .optionallyWith(insecureSsl.map(value => value: java.lang.Boolean))(
        _.insecureSsl
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectSource.wrap(buildAwsValue())
}
object AwsCodeBuildProjectSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectSource =
      zio.aws.securityhub.model.AwsCodeBuildProjectSource(
        `type`.map(value => value),
        location.map(value => value),
        gitCloneDepth.map(value => value),
        insecureSsl.map(value => value)
      )
    def `type`: Option[NonEmptyString]
    def location: Option[NonEmptyString]
    def gitCloneDepth: Option[Integer]
    def insecureSsl: Option[Boolean]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("location", location)
    def getGitCloneDepth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gitCloneDepth", gitCloneDepth)
    def getInsecureSsl: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("insecureSsl", insecureSsl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly {
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val location: Option[NonEmptyString] = scala
      .Option(impl.location())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val gitCloneDepth: Option[Integer] = scala
      .Option(impl.gitCloneDepth())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val insecureSsl: Option[Boolean] =
      scala.Option(impl.insecureSsl()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectSource
  ): zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly = new Wrapper(
    impl
  )
}
