package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(
    groupName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    streamName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails = {
    import AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
      .builder()
      .optionallyWith(
        groupName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        streamName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.streamName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails =
      zio.aws.securityhub.model
        .AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails(
          groupName.map(value => value),
          status.map(value => value),
          streamName.map(value => value)
        )
    def groupName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def streamName: Option[NonEmptyString]
    def getGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getStreamName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("streamName", streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly {
    override val groupName: Option[NonEmptyString] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val streamName: Option[NonEmptyString] = scala
      .Option(impl.streamName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigCloudWatchLogsDetails.ReadOnly =
    new Wrapper(impl)
}
