package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectEnvironment(
    certificate: Option[NonEmptyString] = None,
    environmentVariables: Option[Iterable[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
    ]] = None,
    privilegedMode: Option[Boolean] = None,
    imagePullCredentialsType: Option[NonEmptyString] = None,
    registryCredential: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
    ] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment = {
    import AwsCodeBuildProjectEnvironment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
      .builder()
      .optionallyWith(
        certificate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(
        environmentVariables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentVariables)
      .optionallyWith(privilegedMode.map(value => value: java.lang.Boolean))(
        _.privilegedMode
      )
      .optionallyWith(
        imagePullCredentialsType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.imagePullCredentialsType)
      .optionallyWith(registryCredential.map(value => value.buildAwsValue()))(
        _.registryCredential
      )
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectEnvironment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment =
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment(
        certificate.map(value => value),
        environmentVariables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privilegedMode.map(value => value),
        imagePullCredentialsType.map(value => value),
        registryCredential.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def certificate: Option[NonEmptyString]
    def environmentVariables: Option[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]]
    def privilegedMode: Option[Boolean]
    def imagePullCredentialsType: Option[NonEmptyString]
    def registryCredential: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ]
    def `type`: Option[NonEmptyString]
    def getCertificate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getEnvironmentVariables: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("environmentVariables", environmentVariables)
    def getPrivilegedMode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privilegedMode", privilegedMode)
    def getImagePullCredentialsType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "imagePullCredentialsType",
        imagePullCredentialsType
      )
    def getRegistryCredential: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ] = AwsError.unwrapOptionField("registryCredential", registryCredential)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly {
    override val certificate: Option[NonEmptyString] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val environmentVariables: Option[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.ReadOnly
    ]] = scala
      .Option(impl.environmentVariables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails
            .wrap(item)
        }.toList
      )
    override val privilegedMode: Option[Boolean] =
      scala.Option(impl.privilegedMode()).map(value => value: Boolean)
    override val imagePullCredentialsType: Option[NonEmptyString] = scala
      .Option(impl.imagePullCredentialsType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val registryCredential: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly
    ] = scala
      .Option(impl.registryCredential())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
          .wrap(value)
      )
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironment
  ): zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly =
    new Wrapper(impl)
}
