package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectDetails(
    encryptionKey: Option[NonEmptyString] = None,
    artifacts: Option[
      Iterable[zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails]
    ] = None,
    environment: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment
    ] = None,
    name: Option[NonEmptyString] = None,
    source: Option[zio.aws.securityhub.model.AwsCodeBuildProjectSource] = None,
    serviceRole: Option[NonEmptyString] = None,
    logsConfig: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
    ] = None,
    vpcConfig: Option[zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails = {
    import AwsCodeBuildProjectDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
      .builder()
      .optionallyWith(
        encryptionKey.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKey)
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        serviceRole.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(logsConfig.map(value => value.buildAwsValue()))(
        _.logsConfig
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectDetails.wrap(buildAwsValue())
}
object AwsCodeBuildProjectDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCodeBuildProjectDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectDetails(
        encryptionKey.map(value => value),
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value => value.asEditable),
        name.map(value => value),
        source.map(value => value.asEditable),
        serviceRole.map(value => value),
        logsConfig.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable)
      )
    def encryptionKey: Option[NonEmptyString]
    def artifacts: Option[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]]
    def environment: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ]
    def name: Option[NonEmptyString]
    def source
        : Option[zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly]
    def serviceRole: Option[NonEmptyString]
    def logsConfig: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ]
    def vpcConfig: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ]
    def getEncryptionKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getArtifacts: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getServiceRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getLogsConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logsConfig", logsConfig)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly {
    override val encryptionKey: Option[NonEmptyString] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val artifacts: Option[List[
      zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails.ReadOnly
    ]] = scala
      .Option(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCodeBuildProjectArtifactsDetails
            .wrap(item)
        }.toList
      )
    override val environment: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.ReadOnly
    ] = scala
      .Option(impl.environment())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectEnvironment.wrap(value)
      )
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val source
        : Option[zio.aws.securityhub.model.AwsCodeBuildProjectSource.ReadOnly] =
      scala
        .Option(impl.source())
        .map(value =>
          zio.aws.securityhub.model.AwsCodeBuildProjectSource.wrap(value)
        )
    override val serviceRole: Option[NonEmptyString] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logsConfig: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails.ReadOnly
    ] = scala
      .Option(impl.logsConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigDetails
          .wrap(value)
      )
    override val vpcConfig: Option[
      zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.ReadOnly
    ] = scala
      .Option(impl.vpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsCodeBuildProjectVpcConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectDetails.ReadOnly =
    new Wrapper(impl)
}
