package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginGroupFailover(
    statusCodes: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover = {
    import AwsCloudFrontDistributionOriginGroupFailover.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
      .builder()
      .optionallyWith(statusCodes.map(value => value.buildAwsValue()))(
        _.statusCodes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginGroupFailover {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover(
        statusCodes.map(value => value.asEditable)
      )
    def statusCodes: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly
    ]
    def getStatusCodes: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly
    ] = AwsError.unwrapOptionField("statusCodes", statusCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly {
    override val statusCodes: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly
    ] = scala
      .Option(impl.statusCodes())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailover.ReadOnly =
    new Wrapper(impl)
}
