package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionDetails(
    cacheBehaviors: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
    ] = None,
    defaultCacheBehavior: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
    ] = None,
    defaultRootObject: Option[NonEmptyString] = None,
    domainName: Option[NonEmptyString] = None,
    eTag: Option[NonEmptyString] = None,
    lastModifiedTime: Option[NonEmptyString] = None,
    logging: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionLogging
    ] = None,
    origins: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins
    ] = None,
    originGroups: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups
    ] = None,
    viewerCertificate: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate
    ] = None,
    status: Option[NonEmptyString] = None,
    webAclId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails = {
    import AwsCloudFrontDistributionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails
      .builder()
      .optionallyWith(cacheBehaviors.map(value => value.buildAwsValue()))(
        _.cacheBehaviors
      )
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        defaultRootObject.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultRootObject)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        eTag.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.eTag)
      .optionallyWith(
        lastModifiedTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastModifiedTime)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(origins.map(value => value.buildAwsValue()))(_.origins)
      .optionallyWith(originGroups.map(value => value.buildAwsValue()))(
        _.originGroups
      )
      .optionallyWith(viewerCertificate.map(value => value.buildAwsValue()))(
        _.viewerCertificate
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        webAclId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.webAclId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionDetails
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsCloudFrontDistributionDetails =
      zio.aws.securityhub.model.AwsCloudFrontDistributionDetails(
        cacheBehaviors.map(value => value.asEditable),
        defaultCacheBehavior.map(value => value.asEditable),
        defaultRootObject.map(value => value),
        domainName.map(value => value),
        eTag.map(value => value),
        lastModifiedTime.map(value => value),
        logging.map(value => value.asEditable),
        origins.map(value => value.asEditable),
        originGroups.map(value => value.asEditable),
        viewerCertificate.map(value => value.asEditable),
        status.map(value => value),
        webAclId.map(value => value)
      )
    def cacheBehaviors: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly
    ]
    def defaultCacheBehavior: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly
    ]
    def defaultRootObject: Option[NonEmptyString]
    def domainName: Option[NonEmptyString]
    def eTag: Option[NonEmptyString]
    def lastModifiedTime: Option[NonEmptyString]
    def logging: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly
    ]
    def origins: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly
    ]
    def originGroups: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly
    ]
    def viewerCertificate: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly
    ]
    def status: Option[NonEmptyString]
    def webAclId: Option[NonEmptyString]
    def getCacheBehaviors: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly
    ] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getDefaultCacheBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly
    ] = AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehavior)
    def getDefaultRootObject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultRootObject", defaultRootObject)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getETag: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("eTag", eTag)
    def getLastModifiedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLogging: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly
    ] = AwsError.unwrapOptionField("logging", logging)
    def getOrigins: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly
    ] = AwsError.unwrapOptionField("origins", origins)
    def getOriginGroups: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly
    ] = AwsError.unwrapOptionField("originGroups", originGroups)
    def getViewerCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("viewerCertificate", viewerCertificate)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getWebAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("webAclId", webAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly {
    override val cacheBehaviors: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors.ReadOnly
    ] = scala
      .Option(impl.cacheBehaviors())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehaviors
          .wrap(value)
      )
    override val defaultCacheBehavior: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior.ReadOnly
    ] = scala
      .Option(impl.defaultCacheBehavior())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionDefaultCacheBehavior
          .wrap(value)
      )
    override val defaultRootObject: Option[NonEmptyString] = scala
      .Option(impl.defaultRootObject())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val eTag: Option[NonEmptyString] = scala
      .Option(impl.eTag())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastModifiedTime: Option[NonEmptyString] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logging: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.ReadOnly
    ] = scala
      .Option(impl.logging())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionLogging.wrap(value)
      )
    override val origins: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.ReadOnly
    ] = scala
      .Option(impl.origins())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOrigins.wrap(value)
      )
    override val originGroups: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly
    ] = scala
      .Option(impl.originGroups())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups
          .wrap(value)
      )
    override val viewerCertificate: Option[
      zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly
    ] = scala
      .Option(impl.viewerCertificate())
      .map(value =>
        zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate
          .wrap(value)
      )
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val webAclId: Option[NonEmptyString] = scala
      .Option(impl.webAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionDetails
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionDetails.ReadOnly =
    new Wrapper(impl)
}
