package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionCacheBehavior(
    viewerProtocolPolicy: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehavior = {
    import AwsCloudFrontDistributionCacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehavior
      .builder()
      .optionallyWith(
        viewerProtocolPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.viewerProtocolPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionCacheBehavior {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehavior
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior =
      zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior(
        viewerProtocolPolicy.map(value => value)
      )
    def viewerProtocolPolicy: Option[NonEmptyString]
    def getViewerProtocolPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("viewerProtocolPolicy", viewerProtocolPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehavior
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly {
    override val viewerProtocolPolicy: Option[NonEmptyString] = scala
      .Option(impl.viewerProtocolPolicy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionCacheBehavior
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionCacheBehavior.ReadOnly =
    new Wrapper(impl)
}
