package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateRenewalSummary(
    domainValidationOptions: Option[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
    ]] = None,
    renewalStatus: Option[NonEmptyString] = None,
    renewalStatusReason: Option[NonEmptyString] = None,
    updatedAt: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary = {
    import AwsCertificateManagerCertificateRenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
      .builder()
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(
        renewalStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalStatus)
      .optionallyWith(
        renewalStatusReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalStatusReason)
      .optionallyWith(
        updatedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateRenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        renewalStatus.map(value => value),
        renewalStatusReason.map(value => value),
        updatedAt.map(value => value)
      )
    def domainValidationOptions: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]]
    def renewalStatus: Option[NonEmptyString]
    def renewalStatusReason: Option[NonEmptyString]
    def updatedAt: Option[NonEmptyString]
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getRenewalStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalStatus", renewalStatus)
    def getRenewalStatusReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalStatusReason", renewalStatusReason)
    def getUpdatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly {
    override val domainValidationOptions: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = scala
      .Option(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
    override val renewalStatus: Option[NonEmptyString] = scala
      .Option(impl.renewalStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val renewalStatusReason: Option[NonEmptyString] = scala
      .Option(impl.renewalStatusReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val updatedAt: Option[NonEmptyString] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly =
    new Wrapper(impl)
}
