package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(
    deleteOnTermination: Option[Boolean] = None,
    encrypted: Option[Boolean] = None,
    iops: Option[Integer] = None,
    snapshotId: Option[NonEmptyString] = None,
    volumeSize: Option[Integer] = None,
    volumeType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails = {
    import AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
      .builder()
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        iops.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.iops)
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.volumeSize)
      .optionallyWith(
        volumeType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.volumeType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails(
          deleteOnTermination.map(value => value),
          encrypted.map(value => value),
          iops.map(value => value),
          snapshotId.map(value => value),
          volumeSize.map(value => value),
          volumeType.map(value => value)
        )
    def deleteOnTermination: Option[Boolean]
    def encrypted: Option[Boolean]
    def iops: Option[Integer]
    def snapshotId: Option[NonEmptyString]
    def volumeSize: Option[Integer]
    def volumeType: Option[NonEmptyString]
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("volumeType", volumeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly {
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val iops: Option[Integer] = scala
      .Option(impl.iops())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val snapshotId: Option[NonEmptyString] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumeSize: Option[Integer] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.securityhub.model.primitives.Integer(value))
    override val volumeType: Option[NonEmptyString] = scala
      .Option(impl.volumeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationBlockDeviceMappingsEbsDetails.ReadOnly =
    new Wrapper(impl)
}
