package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails(
    value: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails = {
    import AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails(
          value.map(value => value)
        )
    def value: Option[NonEmptyString]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly {
    override val value: Option[NonEmptyString] = scala
      .Option(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly =
    new Wrapper(impl)
}
