package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsApiGatewayV2StageDetails(
    clientCertificateId: Option[NonEmptyString] = None,
    createdDate: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None,
    defaultRouteSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings
    ] = None,
    deploymentId: Option[NonEmptyString] = None,
    lastUpdatedDate: Option[NonEmptyString] = None,
    routeSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings
    ] = None,
    stageName: Option[NonEmptyString] = None,
    stageVariables: Option[Map[NonEmptyString, NonEmptyString]] = None,
    accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings
    ] = None,
    autoDeploy: Option[Boolean] = None,
    lastDeploymentStatusMessage: Option[NonEmptyString] = None,
    apiGatewayManaged: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails = {
    import AwsApiGatewayV2StageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
      .builder()
      .optionallyWith(
        clientCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clientCertificateId)
      .optionallyWith(
        createdDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdDate)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(defaultRouteSettings.map(value => value.buildAwsValue()))(
        _.defaultRouteSettings
      )
      .optionallyWith(
        deploymentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deploymentId)
      .optionallyWith(
        lastUpdatedDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedDate)
      .optionallyWith(routeSettings.map(value => value.buildAwsValue()))(
        _.routeSettings
      )
      .optionallyWith(
        stageName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .optionallyWith(accessLogSettings.map(value => value.buildAwsValue()))(
        _.accessLogSettings
      )
      .optionallyWith(autoDeploy.map(value => value: java.lang.Boolean))(
        _.autoDeploy
      )
      .optionallyWith(
        lastDeploymentStatusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastDeploymentStatusMessage)
      .optionallyWith(apiGatewayManaged.map(value => value: java.lang.Boolean))(
        _.apiGatewayManaged
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly =
    zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.wrap(buildAwsValue())
}
object AwsApiGatewayV2StageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsApiGatewayV2StageDetails =
      zio.aws.securityhub.model.AwsApiGatewayV2StageDetails(
        clientCertificateId.map(value => value),
        createdDate.map(value => value),
        description.map(value => value),
        defaultRouteSettings.map(value => value.asEditable),
        deploymentId.map(value => value),
        lastUpdatedDate.map(value => value),
        routeSettings.map(value => value.asEditable),
        stageName.map(value => value),
        stageVariables.map(value => value),
        accessLogSettings.map(value => value.asEditable),
        autoDeploy.map(value => value),
        lastDeploymentStatusMessage.map(value => value),
        apiGatewayManaged.map(value => value)
      )
    def clientCertificateId: Option[NonEmptyString]
    def createdDate: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def defaultRouteSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ]
    def deploymentId: Option[NonEmptyString]
    def lastUpdatedDate: Option[NonEmptyString]
    def routeSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ]
    def stageName: Option[NonEmptyString]
    def stageVariables: Option[Map[NonEmptyString, NonEmptyString]]
    def accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ]
    def autoDeploy: Option[Boolean]
    def lastDeploymentStatusMessage: Option[NonEmptyString]
    def apiGatewayManaged: Option[Boolean]
    def getClientCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getCreatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRouteSettings", defaultRouteSettings)
    def getDeploymentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getLastUpdatedDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getRouteSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = AwsError.unwrapOptionField("routeSettings", routeSettings)
    def getStageName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getStageVariables
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
    def getAccessLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogSettings", accessLogSettings)
    def getAutoDeploy: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoDeploy", autoDeploy)
    def getLastDeploymentStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "lastDeploymentStatusMessage",
        lastDeploymentStatusMessage
      )
    def getApiGatewayManaged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("apiGatewayManaged", apiGatewayManaged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ) extends zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly {
    override val clientCertificateId: Option[NonEmptyString] = scala
      .Option(impl.clientCertificateId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdDate: Option[NonEmptyString] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val defaultRouteSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = scala
      .Option(impl.defaultRouteSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.wrap(value)
      )
    override val deploymentId: Option[NonEmptyString] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastUpdatedDate: Option[NonEmptyString] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val routeSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.ReadOnly
    ] = scala
      .Option(impl.routeSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayV2RouteSettings.wrap(value)
      )
    override val stageName: Option[NonEmptyString] = scala
      .Option(impl.stageName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val stageVariables: Option[Map[NonEmptyString, NonEmptyString]] =
      scala
        .Option(impl.stageVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val accessLogSettings: Option[
      zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.ReadOnly
    ] = scala
      .Option(impl.accessLogSettings())
      .map(value =>
        zio.aws.securityhub.model.AwsApiGatewayAccessLogSettings.wrap(value)
      )
    override val autoDeploy: Option[Boolean] =
      scala.Option(impl.autoDeploy()).map(value => value: Boolean)
    override val lastDeploymentStatusMessage: Option[NonEmptyString] = scala
      .Option(impl.lastDeploymentStatusMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val apiGatewayManaged: Option[Boolean] =
      scala.Option(impl.apiGatewayManaged()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2StageDetails
  ): zio.aws.securityhub.model.AwsApiGatewayV2StageDetails.ReadOnly =
    new Wrapper(impl)
}
